/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.io.IOException;
import org.acra.ACRA;
import org.acra.CrashReportPersister;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.util.ToastSender;

public final class CrashReportDialog
extends Activity {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private SharedPreferences prefs;
    private EditText userComment;
    private EditText userEmail;
    String mReportFileName;

    protected void onCreate(Bundle savedInstanceState) {
        int emailPromptId;
        super.onCreate(savedInstanceState);
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        Log.d((String)ACRA.LOG_TAG, (String)("Opening CrashReportDialog for " + this.mReportFileName));
        if (this.mReportFileName == null) {
            this.finish();
        }
        this.requestWindowFeature(3);
        LinearLayout root = new LinearLayout((Context)this);
        root.setOrientation(1);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        root.setFocusable(true);
        root.setFocusableInTouchMode(true);
        final ScrollView scroll = new ScrollView((Context)this);
        root.addView((View)scroll, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout scrollable = new LinearLayout((Context)this);
        scrollable.setOrientation(1);
        scroll.addView((View)scrollable);
        TextView text = new TextView((Context)this);
        text.setText(this.getText(ACRA.getConfig().resDialogText()));
        scrollable.addView((View)text);
        int commentPromptId = ACRA.getConfig().resDialogCommentPrompt();
        if (commentPromptId != 0) {
            String savedValue;
            TextView label = new TextView((Context)this);
            label.setText(this.getText(commentPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            scrollable.addView((View)label, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            if (savedInstanceState != null && (savedValue = savedInstanceState.getString(STATE_COMMENT)) != null) {
                this.userComment.setText((CharSequence)savedValue);
            }
            scrollable.addView((View)this.userComment);
        }
        if ((emailPromptId = ACRA.getConfig().resDialogEmailPrompt()) != 0) {
            TextView label = new TextView((Context)this);
            label.setText(this.getText(emailPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            scrollable.addView((View)label);
            this.userEmail = new EditText((Context)this);
            this.userEmail.setSingleLine();
            this.userEmail.setInputType(33);
            this.prefs = this.getSharedPreferences(ACRA.getConfig().sharedPreferencesName(), ACRA.getConfig().sharedPreferencesMode());
            String savedValue = null;
            if (savedInstanceState != null) {
                savedValue = savedInstanceState.getString(STATE_EMAIL);
            }
            if (savedValue != null) {
                this.userEmail.setText((CharSequence)savedValue);
            } else {
                this.userEmail.setText((CharSequence)this.prefs.getString("acra.user.email", ""));
            }
            scrollable.addView((View)this.userEmail);
        }
        LinearLayout buttons = new LinearLayout((Context)this);
        buttons.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        buttons.setPadding(buttons.getPaddingLeft(), 10, buttons.getPaddingRight(), buttons.getPaddingBottom());
        Button yes = new Button((Context)this);
        yes.setText(17039379);
        yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String usrEmail;
                String comment;
                String string = comment = CrashReportDialog.this.userComment != null ? CrashReportDialog.this.userComment.getText().toString() : "";
                if (CrashReportDialog.this.prefs != null && CrashReportDialog.this.userEmail != null) {
                    usrEmail = CrashReportDialog.this.userEmail.getText().toString();
                    SharedPreferences.Editor prefEditor = CrashReportDialog.this.prefs.edit();
                    prefEditor.putString("acra.user.email", usrEmail);
                    prefEditor.commit();
                } else {
                    usrEmail = "";
                }
                CrashReportPersister persister = new CrashReportPersister(CrashReportDialog.this.getApplicationContext());
                try {
                    Log.d((String)ACRA.LOG_TAG, (String)("Add user comment to " + CrashReportDialog.this.mReportFileName));
                    CrashReportData crashData = persister.load(CrashReportDialog.this.mReportFileName);
                    crashData.put(ReportField.USER_COMMENT, comment);
                    crashData.put(ReportField.USER_EMAIL, usrEmail);
                    persister.store(crashData, CrashReportDialog.this.mReportFileName);
                }
                catch (IOException e) {
                    Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)e);
                }
                Log.v((String)ACRA.LOG_TAG, (String)"About to start SenderWorker from CrashReportDialog");
                ACRA.getErrorReporter().startSendingReports(false, true);
                int toastId = ACRA.getConfig().resDialogOkToast();
                if (toastId != 0) {
                    ToastSender.sendToast(CrashReportDialog.this.getApplicationContext(), toastId, 1);
                }
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)yes, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        Button no = new Button((Context)this);
        no.setText(17039369);
        no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)no, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        root.addView((View)buttons, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.setContentView((View)root);
        int resTitle = ACRA.getConfig().resDialogTitle();
        if (resTitle != 0) {
            this.setTitle(resTitle);
        }
        this.getWindow().setFeatureDrawableResource(3, ACRA.getConfig().resDialogIcon());
        this.cancelNotification();
        scroll.post(new Runnable(){

            @Override
            public void run() {
                scroll.scrollTo(0, 0);
            }
        });
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.userComment != null && this.userComment.getText() != null) {
            outState.putString(STATE_COMMENT, this.userComment.getText().toString());
        }
        if (this.userEmail != null && this.userEmail.getText() != null) {
            outState.putString(STATE_EMAIL, this.userEmail.getText().toString());
        }
    }

    protected void cancelNotification() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(666);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
        }
        return super.onKeyUp(keyCode, event);
    }
}

